;;;   Programm:      ACM-LAYERAUS.LSP
;;;   Befehlsaufruf: ACM-LAYERAUS
;;;   Funktion:      Layer ausschalten per Quellobjektwahl, Auswahlliste oder Option
;;;                  "Vorherige Auswahl".
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         18.08.2024
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-layeraus ( / wms79 wms80 mws01 mws02 mws03 mws04 mws05 mws06 mws07 mws08 mws09 mws10 mws11 mws12 mws13 mws14 mws15 mws16 mws17 mws18)
    (defun mws01 (wms01 wms02 / wms16 wms17 wms18 wms19 wms21 wms20)
      (if (= wms02 "")
        (progn
          (alert "Keine Eingabe fr \042Suchen nach\042.")
          (mode_tile "eb_01" 2)
        )
        (progn
          (setq wms16 (mapcar 'strcase wms01))
          (setq wms17 (strcase wms02))
          (setq wms18 "")
          (setq wms19 -1)
          (setq wms20 0)
            (repeat (length wms16)
              (setq wms19 (1+ wms19))
                (if (wcmatch (nth wms19 wms16) wms17)
                  (progn
                    (setq wms18 (strcat wms18 (itoa wms19) " "))
                    (setq wms20 (1+ wms20))
                  )
                )
            )
            (if
              (and
                (<= wms20 250)
                (/= (setq wms21 (vl-string-trim " " wms18)) "")
              )
                (progn
                  (set_tile "lb_01" "")
                  (set_tile "lb_01" wms21)
                  (mode_tile "b_01" 0)
                )
                (progn
                  (set_tile "lb_01" "0")
                  (set_tile "lb_01" "")
                    (if (> wms20 250)
                      (alert "Ungltige Auswahl. Mehr als 250 entsprechende Layer gefunden.")
                      (alert "Es wurden keine entsprechenden Layer gefunden.")
                    )
                  (mode_tile "eb_01" 2)
                  (mode_tile "b_01" 1)
                )
            )
        )
      )
    )
    (defun mws02 ( / wms22)
      (setq wms22 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= wms22 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq wms23 T)
            (setq wms23 nil)
        )
        (if (not wms23)
          (alert "\042acm-layeraus\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      wms23
    )
    (defun mws03 (wms03 / )
      (if wms77 (vl-catch-all-apply 'setvar (list "CMDECHO" wms77)))
      (if wms78 (vl-catch-all-apply 'setvar (list "EXPERT" wms78)))
      (if wms80 (setq *error* wms80))
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun mws04 ( / wms24 wms39 wms25 wms26)
      (setq wms24 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for wms39 wms24
          (if (= (vla-get-LayerOn wms39) :vlax-true)
            (progn
              (setq wms25 (vlax-get wms39 'Name))
              (setq wms26 (cons wms25 wms26))
            )
          )
        )
        (if wms26
          (acad_strlsort wms26)
          nil
        )
    )
    (defun mws05 ( / wms27 wms28 wms29 wms30)
      (setq wms27 (cdr (assoc 8 acm062024layeraus6saj378112_da451)))
      (setq wms28 (mws07 wms27 ","))
        (while wms28
          (setq wms29 (car wms28))
          (setq wms30 (cons wms29 wms30))
          (setq wms28 (cdr wms28))
        )
        (if wms30
          (progn
            (setq wms30 (acad_strlsort wms30))
            (prompt "\n ")
            (prompt (strcat "\n" (itoa (length wms30)) " Layer wurde(n) ausgeschaltet: "))
              (while wms30
                (prompt (strcat "\n" (car wms30) " "))
                (setq wms30 (cdr wms30))
              )
            (prompt "\n ")
          )
        )
    )
    (defun mws06 ( / wms27 wms28 wms29 wms31 wms32 wms33)
        (if
          (and
            (mws04)
            (= (type acm062024layeraus6saj378112_da451) 'LIST)
            (setq wms27 (cdr (assoc 8 acm062024layeraus6saj378112_da451)))
          )
            (progn
              (setq wms24 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
              (setq wms28 (mws07 wms27 ","))
                (while wms28
                    (if (tblsearch "LAYER" (setq wms29 (car wms28)))
                      (setq wms31 (cons wms29 wms31))
                    )
                  (setq wms28 (cdr wms28))
                )
                (if wms31
                  (setq wms32 (acad_strlsort wms31))
                  (setq wms32 nil)
                )
            )
            (setq wms32 nil)
        )
        (if wms32
          (progn
            (setq wms33 "")
              (while wms32
                (setq wms29 (car wms32))
                (setq wms33 (strcat wms33 wms29 ","))
                (setq wms32 (cdr wms32))
              )
            (setq wms33 (mws13 wms33 1))
            (setq acm062024layeraus6saj378112_da451 (list (cons 8 wms33)))
          )
          (setq acm062024layeraus6saj378112_da451 nil)
        )
    )
    (defun mws07 (wms04 wms05 / wms35 wms36)
      (if
        (and
          (= (type wms04) 'STR)
          (= (type wms05) 'STR)
        )
          (progn
            (setq wms04 (vl-string-trim wms05 wms04))
            (setq wms04 (vl-string-trim " " wms04))
              (while (setq wms35 (vl-string-search wms05 wms04))
                (setq wms36 (append wms36 (list (substr wms04 1 wms35))))
                (setq wms04 (vl-string-left-trim wms05 (substr wms04 (1+ wms35))))
              )
            (setq wms36 (append wms36 (list wms04)))
          )
      )
      wms36
    )
    (defun mws08 (wms06 wms07 / wms37 wms38 wms39 wms35)
      (setq wms37 (strlen wms06))
      (setq wms38 1)
        (while (<= wms38 wms37)
          (setq wms39 (substr wms06 wms38 1))
            (if (/= wms39 wms07)
              (progn
                (setq wms35 nil)
                (setq wms38 (1+ wms38))
              )
            )
            (if (= wms39 wms07)
              (progn
                (setq wms35 wms38)
                (setq wms38 (1+ wms37))
              )
            )
        )
      wms35
    )
    (defun mws09 (wms06 wms08 / wms37 wms39 wms19 wms40)
      (setq wms37 (strlen wms06))
      (setq wms39 (substr wms06 1 1))
      (setq wms19 0)
        (while
          (and
            (/= (member wms39 wms08) nil)
            (/= wms19 wms37)
          )
            (setq wms06 (substr wms06 2))
            (setq wms39 (substr wms06 1 1))
            (setq wms19 (+ wms19 1))
        )
        (if (/= wms19 wms37)
          (progn
            (setq wms37 (strlen wms06))
            (setq wms40 (substr wms06 wms37 1))
            (setq wms19 wms37)
              (while
                (and
                  (/= (member wms40 wms08) nil)
                  (/= wms19 0)
                )
                  (setq wms06 (substr wms06 1 wms19))
                  (setq wms40 (substr wms06 wms19 1))
                  (setq wms19 (- wms19 1))
              )
          )
        )
      wms06
    )
    (defun mws10 (wms09 wms10 / wms41 wms35 wms42 wms23)
      (if
        (and
          (= (type wms09) 'STR)
          (= (type wms10) 'STR)
        )
          (progn
            (setq wms41 (mws09 wms09 (list wms10)))
            (setq wms35 (mws08 wms41 wms10))
              (if wms35
                (progn
                  (setq wms42 (substr wms41 1 (1- wms35)))
                  (setq wms41 (mws09 (substr wms41 (1+ (strlen wms42))) (list wms10)))
                  (setq wms23 (cons wms42 wms23))
                )
              )
            (setq wms35 (mws08 wms41 wms10))
              (while wms35
                (setq wms42 (substr wms41 1 (1- wms35)))
                (setq wms41 (mws09 (substr wms41 (1+ (strlen wms42))) (list wms10)))
                (setq wms23 (cons wms42 wms23))
                (setq wms35 (mws08 wms41 wms10))
              )
              (if (> (strlen wms41) 0)
                (setq wms23 (cons wms41 wms23))
              )
          )
      )
      (if wms23
        (reverse wms23)
        nil
      )
    )
    (defun mws11 ( / wms43 wms44 wms45)
      (prompt "\nAuszuschaltende Layer per Quellobjektewahl bestimmen ... ")
        (if (setq wms43 (ssget))
          (progn
            (setq wms44 (mws16 wms43))
            (setq wms45 (mws12 wms44))
            (setq acm062024layeraus6saj378112_da451 wms45)
          )
        (setq wms45 nil)
        )
        (if wms45
          (list 1 wms45)
          (progn
            (prompt "\nKeine auszuschaltenden Layer gewhlt. ")
            nil
          )
        )
    )
    (defun mws12 (wms11 / wms46 wms33 wms39)
      (setq wms46 wms11)
      (setq wms33 "")
        (while wms46
          (setq wms39 (car wms46))
          (setq wms33 (strcat wms33 wms39 ","))
          (setq wms46 (cdr wms46))
        )
      (setq wms33 (mws13 wms33 1))
        (if (/= wms33 "")
          (list (cons 8 wms33))
          nil
        )
    )
    (defun mws13 (wms12 wms13 / wms37 wms47)
      (setq wms37 (strlen wms12))
        (if (> wms13 wms37)
          (setq wms13 wms37)
        )
      (setq wms47 (- wms37 wms13))
      (setq wms12 (substr wms12 1 wms47))
    )
    (defun mws14 (wms14 / wms48 wms49 wms27 wms50 wms51 wms35 wms52 wms53 wms33 wms54 wms55 wms56 wms57 wms58 wms23)
        (if (setq wms48 (mws15))
          (progn
            (setq wms49 (load_dialog wms48))
              (if (not (new_dialog "acm624lo" wms49))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list wms48))
            (start_list "lb_01")
            (mapcar 'add_list wms14)
            (end_list)
              (if
                (and
                  (= (type acm062024layeraus6saj378112_da451) 'LIST)
                  (setq wms27 (cdr (assoc 8 acm062024layeraus6saj378112_da451)))
                )
                  (progn
                    (setq wms50 (mws07 wms27 ","))
                    (setq wms50 (mapcar 'strcase wms50))
                    (setq wms51 (mapcar 'strcase wms14))
                      (while wms50
                          (if (setq wms35 (vl-position (car wms50) wms51))
                            (setq wms52 (cons wms35 wms52))
                          )
                        (setq wms50 (cdr wms50))
                      )
                      (if wms52
                        (progn
                          (setq wms53 (vl-sort wms52 '<))
                          (setq wms33 "")
                            (while wms53
                              (setq wms33 (strcat wms33 (itoa (car wms53)) " "))
                              (setq wms53 (cdr wms53))
                            )
                          (setq wms54 (mws13 wms33 1))
                        )
                        (setq wms54 nil)
                      )
                  )
                  (setq wms54 nil)
              )
              (if wms54
                (set_tile "lb_01" wms54)
              )
              (if (= (get_tile "lb_01") "")
                (mode_tile "b_01" 1)
              )
            (set_tile "t_01" (strcat (itoa (length (mws10 (get_tile "lb_01") " "))) " Layer gewhlt"))
              (action_tile "lb_01" "(if (> (length (mws10 $value \" \")) 250) 
                  (progn 
                    (alert \"Ungltige Auswahl. Bitte maximal 250 Eintrge whlen.\") 
                    (set_tile $key \"0\") 
                    (set_tile $key \"\") 
                    (mode_tile \"b_01\" 1)
                  ) 
                  (progn 
                      (if (= (get_tile \"lb_01\") \"\") 
                        (mode_tile \"b_01\" 1) 
                        (mode_tile \"b_01\" 0)
                      )
                  )
                )
                (set_tile \"t_01\" (strcat (itoa (length (mws10 (get_tile \"lb_01\") \" \"))) \" Layer gewhlt\"))"
              )
              (action_tile "b_00" "(set_tile \"eb_01\" (setq wms55 (vl-string-trim \" \" (get_tile \"eb_01\"))))
                (mws01 wms14 wms55)
                (set_tile \"t_01\" (strcat (itoa (length (mws10 (get_tile \"lb_01\") \" \"))) \" Layer gewhlt\"))"
              )
              (action_tile "eb_01" "(if (= $reason 1)
                  (progn
                    (set_tile $key (setq wms56 (vl-string-trim \" \" $value)))
                    (mws01 wms14 wms56)
                    (set_tile \"t_01\" (strcat (itoa (length (mws10 (get_tile \"lb_01\") \" \"))) \" Layer gewhlt\"))
                  )
                )"
              )
              (action_tile "b_01" "(setq wms57 (mws10 (setq wms58 (get_tile \"lb_01\")) \" \"))
                (setq wms57 (mapcar 'atoi wms57))
                  (while wms57
                    (setq wms23 (cons (nth (car wms57) wms14) wms23))
                    (setq wms57 (cdr wms57))
                  )
                (setq wms23 (list 1 (setq acm062024layeraus6saj378112_da451 (mws12 (reverse wms23)))))
                (done_dialog)"
              )
            (action_tile "b_02" "(setq wms23 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog wms49)
          )
        )
      wms23
    )
    (defun mws15 ( / wms59 wms60 wms61)
      (if
        (and
          (setq wms59 (vl-filename-mktemp "acm.dcl"))
          (setq wms60 (open wms59 "w"))
        )
          (progn
            (setq wms61
              (list
                "acm624lo"
                ":dialog{label=\042Layer whlen\042;"
                ":spacer{height=0.4;}"
                ":list_box{key=\042lb_01\042;width=35;height=15;multiple_select=true;}"
                ":text{key=\042t_01\042;}"
                ":spacer{height=0;}"
                ":row{"
                ":button{key=\042b_00\042;label=\042&Suchen nach:\042;width=0;fixed_width=true;}"
                ":edit_box{key=\042eb_01\042;width=20;}}"
                ":spacer{height=0.4;}"
                ":row{"
                ":spacer{width=5;}"
                ":column{width=20;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=5;}}}"
              )
            )
              (while wms61
                (write-line (car wms61) wms60)
                (setq wms61 (cdr wms61))
              )
            (setq wms60 (close wms60))
            wms59
          )
          nil
      )
    )
    (defun mws16 (wms15 / wms62 wms63 wms64 wms65 wms66 wms67 wms28)
      (setq wms62 (sslength wms15))
      (setq wms63 -1)
      (setq wms64 0)
        (repeat wms62
          (setq wms63 (1+ wms63))
          (setq wms65 (ssname wms15 wms63))
          (setq wms66 (vlax-ename->vla-object wms65))
          (setq wms67 (vlax-get wms66 'Layer))
            (if (not (vl-position wms67 wms28))
              (setq wms28 (cons wms67 wms28))
            )
        )
      wms28
    )
    (defun mws17 ( / wms69 wms70 wms71)
        (if (not (vl-position acm062024layeraus7saj378112_da451 (list 0 1 2 3)))
          (setq acm062024layeraus7saj378112_da451 0)
        )
        (if (= (type acm062024layeraus6saj378112_da451) 'LIST)
          (progn
            (setq wms69 "Objektwahl Vorherige auSwahlliste Alle")
              (if (= acm062024layeraus7saj378112_da451 0)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/Vorherige auswahl/auSwahlliste/Alle] <Objektwahl>: ")
              )
              (if (= acm062024layeraus7saj378112_da451 1)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/Vorherige auswahl/auSwahlliste/Alle] <Vorherige auswahl>: ")
              )
              (if (= acm062024layeraus7saj378112_da451 2)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/Vorherige auswahl/auSwahlliste/Alle] <auSwahlliste>: ")
              )
              (if (= acm062024layeraus7saj378112_da451 3)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/Vorherige auswahl/auSwahlliste/Alle] <Alle>: ")
              )
          )
          (progn
              (if (not (vl-position acm062024layeraus7saj378112_da451 (list 0 2 3)))
                (setq acm062024layeraus7saj378112_da451 0)
              )
            (setq wms69 "Objektwahl auSwahlliste Alle")
              (if (= acm062024layeraus7saj378112_da451 0)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/auSwahlliste/Alle] <Objektwahl>: ")
              )
              (if (= acm062024layeraus7saj378112_da451 2)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/auSwahlliste/Alle] <auSwahlliste>: ")
              )
              (if (= acm062024layeraus7saj378112_da451 3)
                (setq wms70 "\nAuszuschaltende Layer whlen durch [Objektwahl/auSwahlliste/Alle] <Alle>: ")
              )
          )
        )
      (initget wms69)
        (if (setq wms71 (getkword wms70))
          (setq acm062024layeraus7saj378112_da451 (nth (vl-position wms71 (list "Objektwahl" "Vorherige" "auSwahlliste" "Alle")) (list 0 1 2 3)))
        )
      acm062024layeraus7saj378112_da451
    )
    (defun mws18 ( / wms77 wms78 wms72 wms73 wms74 wms75 wms28 wms24 wms76)
        (if (setq wms72 (mws04))
          (progn
            (mws06)
            (setq wms73 (mws17))
              (if (= wms73 0)
                (setq wms74 (mws11))
              )
              (if (= wms73 1)
                (setq wms74 (list 1 acm062024layeraus6saj378112_da451))
              )
              (if (= wms73 2)
                (setq wms74 (mws14 wms72))
              )
              (if (vl-position wms73 (list 0 1 2))
                (progn
                  (if wms74
                    (progn
                      (setq acm062024layeraus6saj378112_da451 (cadr wms74))
                      (mws05)
                      (setq wms75 (cdr (assoc 8 acm062024layeraus6saj378112_da451)))
                      (setq wms28 (mws07 wms75 ","))
                      (setq wms24 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
                        (while wms28
                          (setq wms76 (vla-Item wms24 (car wms28)))
                          (vl-catch-all-apply 'vla-put-LayerOn (list wms76 :vlax-false))
                          (setq wms28 (cdr wms28))
                        )
                    )
                  )
                )
                (progn
                  (if (= wms73 3)
                    (progn
                      (setq wms77 (getvar "CMDECHO"))
                      (setvar "CMDECHO" 0)
                      (setq wms78 (getvar "EXPERT"))
                      (setvar "EXPERT" 5)
                      (vl-cmdf "._-layer" "_off" "*" "")
                      (setvar "EXPERT" wms78)
                      (setvar "CMDECHO" wms77)
                      (prompt "\nAlle Layer wurden ausgeschaltet. ")
                    )
                  )
                )
              )
          )
          (alert "Alle Layer sind bereits ausgeschaltet.")
        )
    )
  (if (mws02)
    (progn
      (vl-load-com)
      (sssetfirst nil nil)
      (setq wms79 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq wms80 *error*)
      (setq *error* mws03)
      (vla-EndUndoMark wms79)
      (vla-StartUndoMark wms79)
      (mws18)
        (if wms80
          (setq *error* wms80)
          (setq *error* nil)
        )
      (vla-EndUndoMark wms79)
    )
  )
  (princ)
)
(terpri)
(princ (strcat "\nAutoLISP-Tool ACM-LAYERAUS (Copyright  " (substr (rtos (getvar "CDATE")) 1 4) " Gerhard Rampf) geladen. "))
(princ "\nRufen Sie den Befehl mit ACM-LAYERAUS auf.")
